//+------------------------------------------------------------------+
//| MTF_Daily-Weekly_HL_Band
//+------------------------------------------------------------------+
#property copyright "Copyright(c)2009 latimeria (lohikeitto)"

#property indicator_chart_window
#property indicator_buffers 4

#property indicator_color1 Lime
#property indicator_color2 OrangeRed
#property indicator_color3 BlueViolet
#property indicator_color4 Crimson

#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 2
#property indicator_width4 2

extern bool ShowDailyHL = true;
extern bool ShowWeeklyHL = true;

double Daily_H[];
double Daily_L[];
double Weekly_H[];
double Weekly_L[];

//+------------------------------------------------------------------+
//| init
//+------------------------------------------------------------------+
int init()
{
   SetIndexBuffer(0,Daily_H);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexLabel(0,"Daily_H");

   SetIndexBuffer(1,Daily_L);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexLabel(1,"Daily_L");

   SetIndexBuffer(2,Weekly_H);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexLabel(2,"Weekly_H");

   SetIndexBuffer(3,Weekly_L);
   SetIndexStyle(3,DRAW_LINE);
   SetIndexLabel(3,"Weekly_L");

   IndicatorShortName("MTF_Daily-Weekly_HL_Band");
   
   IndicatorDigits(Digits);

   return(0);
}

//+------------------------------------------------------------------+
//| start
//+------------------------------------------------------------------+
int start()
{
   int i, limit;
   int counted_bars = IndicatorCounted();
   
   if(counted_bars < 0) return(-1);
   if(counted_bars > 0) counted_bars--;
   
   // Daily
   datetime TimeArray_D1[]; int d=0;
   ArrayCopySeries(TimeArray_D1,MODE_TIME,Symbol(),1440);
   limit = Bars - counted_bars + 1440/Period();
   
   for(i=0; i<limit; i++)
   {
      if (Time[i] < TimeArray_D1[d]) d++; 
   
      if(ShowDailyHL)
      {
         Daily_H[i] = iHigh(Symbol(), 1440, d);
         Daily_L[i] = iLow(Symbol(), 1440, d);
      }
      else
      { Daily_H[i] = 0.0; Daily_L[i] = 0.0; }
   }
     
   // Weekly
   datetime TimeArray_W1[]; int w=0;
   ArrayCopySeries(TimeArray_W1,MODE_TIME,Symbol(),10080);
   limit = Bars - counted_bars + 10080/Period();
   
   for(i=0; i<limit; i++)
   {
      if (Time[i] < TimeArray_W1[w]) w++; 
   
      if(ShowWeeklyHL)
      {
         Weekly_H[i] = iHigh(Symbol(), 10080, w);
         Weekly_L[i] = iLow(Symbol(), 10080, w);
      }
      else
      { Weekly_H[i] = 0.0; Weekly_L[i] = 0.0; }
   }

   return(0);
}